﻿using Microsoft.Azure.WebJobs;
using VA.PPMS.IWS.Functions.Configuration.Interface;

namespace VA.PPMS.IWS.Functions
{
    public class ConfigNameResolver : INameResolver
    {
        private readonly IIwsConfiguration _configuration;

        public ConfigNameResolver(IIwsConfiguration configuration)
        {
            _configuration = configuration;
        }

        public string Resolve(string name)
        {
            return _configuration.GeTargetName(name).GetAwaiter().GetResult();
        }
    }
}